package cn.com.duiba.cloud.manage.service.sdk.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 管理后台权限注解
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/15
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
@Inherited
public @interface MgtAuthority {

    /**
     * 权限名称
     * @return
     */
    String name();

    /**
     * 权限code
     * @return
     */
    String code();

    /**
     * 无权限的提示信息
     * @return
     */
    String message() default "无权访问该资源";

}
