package cn.com.duiba.cloud.manage.service.sdk.enums;

/**
 * redis缓存key
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/12/20
 */
public enum SdkRedisKeyEnum {

    /**
     * 租户权益缓存
     */
    TENANT_APP_RIGHTS_CACHE("租户应用权益缓存", "DUIBA_MANAGE_SERVICE:TENANT_APP_RIGHTS:%s_%s"),
    /**
     * 员工权限缓存
     */
    STAFF_APP_AUTHORITY_CACHE("员工权限缓存", "DUIBA_MANAGE_SERVICE:STAFF_APP_AUTHORITY:%s_%s_%s"),

    ;

    private final String desc;
    private final String template;

    SdkRedisKeyEnum(String desc, String template) {
        this.desc = desc;
        this.template = template;
    }

    public static String getRedisKey(SdkRedisKeyEnum keyTemplate, Object... args) {
        return String.format(keyTemplate.template, args);
    }

}
