package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtAuthority;
import cn.com.duiba.cloud.manage.service.sdk.constant.MgtSdkConstant;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Objects;

/**
 * 权限处理handler
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/15
 */
@Slf4j
public class MgtAuthorityHandler implements SsoFilterHandler {

    @Resource
    private PermissionVerification permissionVerification;

    @Override
    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;
            MgtAuthority authority = AnnotationUtils.findAnnotation(method.getMethod(), MgtAuthority.class);
            if (Objects.isNull(authority)) {
                // 无权限注解不校验
                return Boolean.TRUE;
            }

            try {
                Boolean verify = null;
                Long tenantId = null;
                Long staffId = null;
                Long tenantAppId = null;
                try {
                    tenantId = (Long) SsoRequestTool.getRequestParams().getAdminInfo().get(MgtSdkConstant.TENANT_ID);
                    staffId = (Long) SsoRequestTool.getRequestParams().getAdminInfo().get(MgtSdkConstant.STAFF_ID);
                    tenantAppId = (Long) SsoRequestTool.getRequestParams().getAdminInfo().get(MgtSdkConstant.TENANT_APP_ID);
                    verify = permissionVerification.verifyAuthority(tenantId, tenantAppId, staffId, authority.code());
                } catch (BizException e) {
                    log.error("auth [{}] access error, tenantId:{},tenantAppId:{},staffId:{},errCode:{},errMsg:{}", authority.code(), tenantId, tenantAppId, staffId, e.getCode(), e.getMessage());
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(e.getCode(), e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                    return false;
                }

                // 4.判断返回信息
                if (!verify) {
                    log.warn("auth [{}] access fail, tenantId:{},tenantAppId:{},staffId:{}", authority.code(), tenantId, tenantAppId, staffId);
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(MgtSdkConstant.NO_AUTH_CODE, authority.message());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                }
                return verify;
            } catch (IOException e) {
                throw new SsoRunTimeException(e);
            }

        }
        // 非方法不校验
        return Boolean.TRUE;
    }

    @Override
    public int getOrder() {
        return 50;
    }
}
