package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtRights;
import cn.com.duiba.cloud.manage.service.sdk.constant.MgtSdkConstant;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.model.VerifyRightsRes;
import cn.com.duiba.cloud.manage.service.sdk.util.PermissionUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

/**
 * 权益处理
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/12/17
 */
public class MgtRightsHandler implements SsoFilterHandler {

    @Resource
    private PermissionVerification permissionVerification;

    @Override
    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            // 1. 获取权益注解
            HandlerMethod method = (HandlerMethod) handler;
            MgtRights rights = AnnotationUtils.findAnnotation(method.getMethod(), MgtRights.class);
            if (Objects.isNull(rights)) {
                return Boolean.TRUE;
            }

            // 2. 调用远程判断权限是否存在
            String code = rights.code();
            Long tenantId = (Long) SsoRequestTool.getRequestParams().getAdminInfo().get(MgtSdkConstant.TENANT_ID);
            Long tenantAppId = (Long) SsoRequestTool.getRequestParams().getAdminInfo().get(MgtSdkConstant.TENANT_APP_ID);

            try {
                VerifyRightsRes res = null;
                try {
                    res = permissionVerification.verifyRights(tenantId, tenantAppId, code);
                } catch (BizException e) {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(e.getCode(), e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                    return false;
                }

                if (res == null || !res.getAccess()) {
                    // 无权益
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(MgtSdkConstant.NO_RIGHTS_CODE, rights.message());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                    return false;
                }

                // 3. 获取权益内容
                String content = res.getContent();
                if (StringUtils.isNotBlank(content)) {
                    Map<String, Object> contentMap = JSONObject.parseObject(content, Map.class);
                    PermissionUtil.putAll(contentMap);
                }
                return Boolean.TRUE;

            } catch (IOException e) {
                throw new SsoRunTimeException(e);
            }

        }
        // 非方法不校验
        return Boolean.TRUE;

    }

    @Override
    public int getOrder() {
        return 30;
    }
}
