package cn.com.duiba.cloud.manage.service.sdk.handler.verification.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.model.VerifyRightsRes;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkStaffAuthorityDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkTenantRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.service.MgtPermissionService;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 缓存权限权益校验
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/12/20
 */
public class CachedPermissionVerification implements PermissionVerification {

    private final MgtPermissionService mgtPermissionService;

    public CachedPermissionVerification(MgtPermissionService mgtPermissionService) {
        this.mgtPermissionService = mgtPermissionService;
    }

    @Override
    public Boolean verifyAuthority(Long tenantId, Long tenantAppId, Long staffId, String authCode) throws BizException {

        SdkStaffAuthorityDTO dto = mgtPermissionService.getAuthorityByCached(tenantId, tenantAppId, staffId);
        if (Objects.isNull(dto) || CollectionUtils.isEmpty(dto.getAuthList())) {
            return false;
        }
        return dto.getAuthList().stream().anyMatch(o -> authCode.equals(o.getCode()));
    }

    @Override
    public VerifyRightsRes verifyRights(Long tenantId, Long tenantAppId, String rightsCode) throws BizException {
        VerifyRightsRes res = new VerifyRightsRes();
        res.setAccess(false);

        SdkTenantRightsDTO dto = mgtPermissionService.getRightsByCached(tenantId, tenantAppId);
        if (Objects.isNull(dto) || CollectionUtils.isEmpty(dto.getRightsList())) {
            return res;
        }

        List<SdkRightsDTO> rightsList = dto.getRightsList();
        Optional<SdkRightsDTO> opt = rightsList.stream()
                .filter(o -> rightsCode.equals(o.getRightsCode()))
                .max(Comparator.comparingInt(SdkRightsDTO::getLevel));
        if (opt.isPresent()) {
            SdkRightsDTO info = opt.get();
            res.setAccess(true);
            res.setContent(info.getRightsContent());
            return res;
        }
        return res;
    }


}
