package cn.com.duiba.cloud.manage.service.sdk.service;

import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkStaffAuthorityDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkTenantRightsDTO;

import java.util.List;

/**
 * 权限权益服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/12/20
 */
public interface MgtPermissionService {

    /**
     * 通过缓存获取权益
     * @param tenantId
     * @return
     */
    SdkTenantRightsDTO getRightsByCached(Long tenantId, Long tenantAppId);

    /**
     * 清除租户权益缓存
     * @param tenantId
     * @return
     */
    boolean removeRightsCache(Long tenantId, List<Long> tenantAppIds);

    /**
     * 通过缓存获取权限
     * @param staffId
     * @param tenantId
     * @return
     */
    SdkStaffAuthorityDTO getAuthorityByCached(Long tenantId, Long tenantAppId, Long staffId);

    /**
     * 删除员工权限缓存
     * @param tenantId
     * @param staffIds
     * @return
     */
    boolean removeAuthorityCache(Long tenantId, Long tenantAppId, List<Long> staffIds);


}
