/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtAuthority;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class MgtAuthorityHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(MgtAuthorityHandler.class);
    @Resource
    private PermissionVerification permissionVerification;

    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            MgtAuthority authority = (MgtAuthority)AnnotationUtils.findAnnotation((Method)method.getMethod(), MgtAuthority.class);
            if (Objects.isNull(authority)) {
                return Boolean.TRUE;
            }
            try {
                Boolean verify = null;
                Long tenantId = null;
                Long staffId = null;
                Long tenantAppId = null;
                try {
                    tenantId = (Long)SsoRequestTool.getRequestParams().getAdminInfo().get((Object)"tenantId");
                    staffId = (Long)SsoRequestTool.getRequestParams().getAdminInfo().get((Object)"staffId");
                    tenantAppId = (Long)SsoRequestTool.getRequestParams().getAdminInfo().get((Object)"tenantAppId");
                    verify = this.permissionVerification.verifyAuthority(tenantId, tenantAppId, staffId, authority.code());
                }
                catch (BizException e) {
                    log.error("auth [{}] access error, tenantId:{},tenantAppId:{},staffId:{},errCode:{},errMsg:{}", new Object[]{authority.code(), tenantId, tenantAppId, staffId, e.getCode(), e.getMessage()});
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)e.getCode(), (String)e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return false;
                }
                if (!verify.booleanValue()) {
                    log.warn("auth [{}] access fail, tenantId:{},tenantAppId:{},staffId:{}", new Object[]{authority.code(), tenantId, tenantAppId, staffId});
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)"mss000001", (String)authority.message());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                }
                return verify;
            }
            catch (IOException e) {
                throw new SsoRunTimeException((Throwable)e);
            }
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 50;
    }
}

