/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.enums.SdkRedisKeyEnum;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkStaffAuthorityDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkTenantRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteQueryStaffAuthorityParam;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteQueryTenantAppRightsParam;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtPermissionService;
import cn.com.duiba.cloud.manage.service.sdk.service.MgtPermissionService;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MgtPermissionServiceImpl
implements MgtPermissionService {
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Resource
    private RemoteMgtPermissionService remoteMgtPermissionService;
    @Value(value="${duiba.mgt.auth.expire_time_minute:60}")
    private int authExpireTime;

    @Override
    public SdkTenantRightsDTO getRightsByCached(Long tenantId, Long tenantAppId) {
        Date now = new Date();
        Date dayEndTime = DateUtils.getDayEndTime((Date)now);
        long timeout = dayEndTime.getTime() - now.getTime();
        return (SdkTenantRightsDTO)this.advancedCacheClient.getWithCacheLoader(SdkRedisKeyEnum.getRedisKey(SdkRedisKeyEnum.TENANT_APP_RIGHTS_CACHE, tenantId, tenantAppId), (int)timeout, TimeUnit.MILLISECONDS, true, () -> {
            RemoteQueryTenantAppRightsParam remoteParam = new RemoteQueryTenantAppRightsParam();
            remoteParam.setTenantId(tenantId);
            remoteParam.setTenantAppId(tenantAppId);
            try {
                return this.remoteMgtPermissionService.queryTenantAppRights(remoteParam);
            }
            catch (BizException e) {
                throw new SsoRunTimeException("\u83b7\u53d6\u79df\u6237\u6743\u76ca\u5f02\u5e38", (Throwable)e);
            }
        });
    }

    @Override
    public boolean removeRightsCache(Long tenantId, List<Long> tenantAppIds) {
        if (Objects.isNull(tenantId) || CollectionUtils.isEmpty(tenantAppIds)) {
            throw new IllegalArgumentException("\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        List<String> redisKeyList = tenantAppIds.stream().map(o -> SdkRedisKeyEnum.getRedisKey(SdkRedisKeyEnum.TENANT_APP_RIGHTS_CACHE, tenantId, o)).collect(Collectors.toList());
        return this.advancedCacheClient.remove(redisKeyList.toArray(new String[0]));
    }

    @Override
    public SdkStaffAuthorityDTO getAuthorityByCached(Long tenantId, Long tenantAppId, Long staffId) {
        int expireTime = this.authExpireTime * 60 * 1000;
        Date now = new Date();
        Date dayEndTime = DateUtils.getDayEndTime((Date)now);
        long remainTime = dayEndTime.getTime() - now.getTime();
        if (remainTime < (long)expireTime) {
            expireTime = (int)remainTime;
        }
        return (SdkStaffAuthorityDTO)this.advancedCacheClient.getWithCacheLoader(SdkRedisKeyEnum.getRedisKey(SdkRedisKeyEnum.STAFF_APP_AUTHORITY_CACHE, tenantId, tenantAppId, staffId), expireTime, TimeUnit.MILLISECONDS, true, () -> {
            RemoteQueryStaffAuthorityParam remoteParam = new RemoteQueryStaffAuthorityParam();
            remoteParam.setTenantId(tenantId);
            remoteParam.setTenantAppId(tenantAppId);
            remoteParam.setStaffId(staffId);
            try {
                return this.remoteMgtPermissionService.queryStaffAuthority(remoteParam);
            }
            catch (BizException e) {
                throw new SsoRunTimeException("\u83b7\u53d6\u5458\u5de5\u6743\u9650\u5f02\u5e38", (Throwable)e);
            }
        });
    }

    @Override
    public boolean removeAuthorityCache(Long tenantId, Long tenantAppId, List<Long> staffIds) {
        if (Objects.isNull(tenantId) || Objects.isNull(tenantAppId) || CollectionUtils.isEmpty(staffIds)) {
            throw new IllegalArgumentException("\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        List<String> redisKeyList = staffIds.stream().map(o -> SdkRedisKeyEnum.getRedisKey(SdkRedisKeyEnum.STAFF_APP_AUTHORITY_CACHE, tenantId, tenantAppId, o)).collect(Collectors.toList());
        return this.advancedCacheClient.remove(redisKeyList.toArray(new String[0]));
    }
}

