/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.config;

import cn.com.duiba.cloud.manage.service.sdk.handler.MgtAuthorityHandler;
import cn.com.duiba.cloud.manage.service.sdk.handler.MgtRightsHandler;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.impl.CachedPermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.impl.RemotePermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtPermissionService;
import cn.com.duiba.cloud.manage.service.sdk.service.MgtPermissionService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"cn.com.duiba.cloud.manage.service.sdk"})
public class MgtPermissionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MgtRightsHandler mgtRightsHandler() {
        return new MgtRightsHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public MgtAuthorityHandler mgtAuthorityHandler() {
        return new MgtAuthorityHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="duiba.mgt.permission_verification", value={"strategy"}, havingValue="remote")
    public PermissionVerification permissionVerificationRemote(RemoteMgtPermissionService service) {
        return new RemotePermissionVerification(service);
    }

    @Bean
    @ConditionalOnProperty(prefix="duiba.mgt.permission_verification", value={"strategy"}, havingValue="cache", matchIfMissing=true)
    public PermissionVerification permissionVerificationCache(MgtPermissionService service) {
        return new CachedPermissionVerification(service);
    }
}

