/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.controller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.RedisKeyEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppCookieQueryParam;
import cn.com.duiba.cloud.manage.service.api.remoteservice.app.RemoteAppService;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.annotation.CanAccess;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"appClient"})
public class AppClientController {
    private static final Logger log = LoggerFactory.getLogger(AppClientController.class);
    @Resource
    private RemoteAppService remoteAppService;

    @CanAccess
    @RequestMapping(value={"index"})
    public String index(@RequestParam Long innerUserId, @RequestParam(required=false) String redirect) throws BizException {
        RemoteAppCookieQueryParam param = new RemoteAppCookieQueryParam();
        String key = RedisKeyEnum.getRedisKey((RedisKeyEnum)RedisKeyEnum.APP_COOKIE_INFO, (Object[])new Object[]{innerUserId});
        param.setKey(key);
        List cookieList = this.remoteAppService.getAppCookieInfo(param);
        if (CollectionUtils.isEmpty((Collection)cookieList)) {
            throw new BizException("\u65e0\u6548\u7684cookie\u4fe1\u606f");
        }
        log.info("cookie info: {}", (Object)JSONObject.toJSONString((Object)cookieList));
        for (Cookie cookie : cookieList) {
            SsoRequestTool.addCookie((Cookie)cookie);
        }
        return "redirect:" + redirect;
    }
}

