/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.cloud.manage.service.api.model.enums.RedisKeyEnum;
import cn.com.duiba.cloud.manage.service.sdk.config.CookieConfig;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.TokenCookieDTO;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class CustomHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomHandler.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public Boolean before(Object handler) throws SsoException {
        LoginUtil.checkUserId();
        String manageTku = SsoRequestTool.getCookie((String)CookieConfig.COOKIE_NAME);
        TokenCookieDTO tokenCookieDTO = (TokenCookieDTO)JSONObject.parseObject((String)BlowfishUtils.decryptBlowfish((String)manageTku, (String)CookieConfig.KEY_ENCRYPT), TokenCookieDTO.class);
        JSONObject adminInfo = SsoRequestTool.getRequestParams().getAdminInfo();
        if (tokenCookieDTO.getTenantId() != null) {
            String key = RedisKeyEnum.getRedisKey((RedisKeyEnum)RedisKeyEnum.TENANT_STAFF_REL, (Object[])new Object[]{tokenCookieDTO.getInnerUserId(), tokenCookieDTO.getTenantId()});
            String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (value == null) {
                LoginUtil.saveCookie(LoginUtil.getCookieUserId(), null, null);
                return Boolean.TRUE;
            }
        }
        adminInfo.put("staffId", (Object)tokenCookieDTO.getStaffId());
        adminInfo.put("tenantId", (Object)tokenCookieDTO.getTenantId());
        adminInfo.put("tenantAppId", (Object)LoginUtil.getTenantAppIdOrNull());
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 20;
    }
}

