/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.sdk.config.CookieConfig;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.ParamHeaderDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.TokenCookieDTO;
import cn.com.duiba.cloud.manage.service.sdk.util.RequestUtils;
import cn.com.duiba.cloud.single.sign.on.client.tool.SsoContext;
import cn.com.duiba.cloud.single.sign.on.contract.tool.CookieUtil;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class LoginUtil {
    private static final Logger log = LoggerFactory.getLogger(LoginUtil.class);
    private static final ThreadLocal<HttpRequestDto> LOCAL = new InheritableThreadLocal<HttpRequestDto>();

    public static Long getTenantAppId() throws BizException {
        log.info("\u83b7\u53d6\u672c\u5730\u7ebf\u7a0b\u6c60\u6570\u636e: {}", (Object)LoginUtil.get().toString());
        ParamHeaderDTO paramCookie = LoginUtil.get().getParamHeader();
        AssertUtil.isTrue((paramCookie != null && paramCookie.getTenantAppId() != null ? 1 : 0) != 0, (ErrorCode)ErrorCode.APP_INFO_INVALID, (Object[])new Object[0]);
        return paramCookie.getTenantAppId();
    }

    public static Long getTenantId() throws BizException {
        log.info("\u83b7\u53d6\u672c\u5730\u7ebf\u7a0b\u6c60\u6570\u636e: {}", (Object)LoginUtil.get().toString());
        TokenCookieDTO tokenCookieDTO = LoginUtil.get().getTokenCookie();
        AssertUtil.isTrue((tokenCookieDTO != null && tokenCookieDTO.getTenantId() != null ? 1 : 0) != 0, (ErrorCode)ErrorCode.TENANT_NOT_NULL, (Object[])new Object[0]);
        return tokenCookieDTO.getTenantId();
    }

    public static Long getInnerUserId() throws BizException {
        log.info("\u83b7\u53d6\u672c\u5730\u7ebf\u7a0b\u6c60\u6570\u636e: {}", (Object)LoginUtil.get().toString());
        TokenCookieDTO tokenCookieDTO = LoginUtil.get().getTokenCookie();
        AssertUtil.isTrue((tokenCookieDTO != null && tokenCookieDTO.getInnerUserId() != null ? 1 : 0) != 0, (ErrorCode)ErrorCode.TENANT_NOT_NULL, (Object[])new Object[0]);
        return tokenCookieDTO.getInnerUserId();
    }

    public static Long getStaffId() throws BizException {
        log.info("\u83b7\u53d6\u672c\u5730\u7ebf\u7a0b\u6c60\u6570\u636e: {}", (Object)LoginUtil.get().toString());
        TokenCookieDTO tokenCookieDTO = LoginUtil.get().getTokenCookie();
        AssertUtil.isTrue((tokenCookieDTO != null && tokenCookieDTO.getStaffId() != null ? 1 : 0) != 0, (ErrorCode)ErrorCode.TENANT_NOT_NULL, (Object[])new Object[0]);
        return tokenCookieDTO.getStaffId();
    }

    public static void setThreadLocally(HttpServletRequest request, HttpServletResponse response, String tku) {
        LoginUtil.clearThreadLocally();
        Assert.notNull((Object)request, (String)"RequestUtils \u6ce8\u5165 request \u4e3a\u7a7a");
        Assert.notNull((Object)response, (String)"RequestUtils\u6ce8\u5165 response \u4e3a\u7a7a");
        LoginUtil.get().init(request, response, tku);
        log.info("\u8bbe\u7f6e\u672c\u5730\u7ebf\u7a0b\u6c60\u6570\u636e: {}", (Object)LoginUtil.get().toString());
        log.info("\u8bbe\u7f6e\u672c\u5730\u7ebf\u7a0b\u6c60\u7684\u8bf7\u6c42URI: {}", (Object)LoginUtil.get().getRequest().getRequestURI());
    }

    private static HttpRequestDto get() {
        HttpRequestDto httpRequestDto = LOCAL.get();
        if (null == httpRequestDto) {
            httpRequestDto = new HttpRequestDto();
            LOCAL.set(httpRequestDto);
        }
        return httpRequestDto;
    }

    public static void clearThreadLocally() {
        LOCAL.remove();
    }

    public static void saveCookie(Long innerUserId, Long tenantId, Long staffId) {
        TokenCookieDTO tokenCookieDTO = new TokenCookieDTO();
        tokenCookieDTO.setInnerUserId(innerUserId);
        tokenCookieDTO.setTenantId(tenantId);
        tokenCookieDTO.setStaffId(staffId);
        tokenCookieDTO.setTime(System.currentTimeMillis());
        String cookie = BlowfishUtils.encryptBlowfish((String)JSONObject.toJSONString((Object)tokenCookieDTO), (String)CookieConfig.KEY_ENCRYPT);
        SsoRequestTool.addCookie((Cookie)CookieUtil.createCookie((String)CookieConfig.COOKIE_NAME, (String)cookie, (Integer)5184000));
    }

    public static String getTenantCookieDto(Long innerUserId, Long tenantId, Long staffId) {
        TokenCookieDTO tokenCookieDTO = new TokenCookieDTO();
        tokenCookieDTO.setInnerUserId(innerUserId);
        tokenCookieDTO.setTenantId(tenantId);
        tokenCookieDTO.setStaffId(staffId);
        tokenCookieDTO.setTime(System.currentTimeMillis());
        return BlowfishUtils.encryptBlowfish((String)JSONObject.toJSONString((Object)tokenCookieDTO), (String)CookieConfig.KEY_ENCRYPT);
    }

    public static void updateCookieTime() {
        String manageTku = SsoRequestTool.getCookie((String)CookieConfig.COOKIE_NAME);
        SsoRequestTool.addCookie((Cookie)CookieUtil.createCookie((String)CookieConfig.COOKIE_NAME, (String)manageTku, (Integer)5184000));
    }

    public static void checkUserId() {
        Long ssoUserId;
        String ssoId = SsoRequestTool.getRequest().getParameter("innerUserId");
        if (StringUtils.isBlank((CharSequence)ssoId)) {
            ssoUserId = SsoContext.getLoginState().getUserId();
        } else {
            log.info("\u79df\u6237\u8df3\u8f6c\u5e94\u7528\u53c2\u6570 innerUserId: {}", (Object)ssoId);
            ssoUserId = Long.valueOf(ssoId);
        }
        Long userId = LoginUtil.getCookieUserId();
        if (ObjectUtils.notEqual((Object)ssoUserId, (Object)userId)) {
            LoginUtil.setThreadLocally(SsoRequestTool.getRequest(), SsoRequestTool.getResponse(), null);
            LoginUtil.saveCookie(ssoUserId, null, null);
        } else {
            LoginUtil.setThreadLocally(SsoRequestTool.getRequest(), SsoRequestTool.getResponse(), SsoRequestTool.getCookie((String)CookieConfig.COOKIE_NAME));
            LoginUtil.updateCookieTime();
        }
    }

    public static Long getCookieUserId() {
        TokenCookieDTO tokenCookieDTO = LoginUtil.parseCookie();
        if (tokenCookieDTO == null) {
            return null;
        }
        return tokenCookieDTO.getInnerUserId();
    }

    private static TokenCookieDTO parseCookie() {
        String manageTku = SsoRequestTool.getCookie((String)CookieConfig.COOKIE_NAME);
        return RequestUtils.getTokenCookie(manageTku);
    }

    public static Long getTenantIdOrNull() {
        TokenCookieDTO tokenCookieDTO = LoginUtil.get().getTokenCookie();
        if (tokenCookieDTO != null && tokenCookieDTO.getTenantId() != null) {
            return tokenCookieDTO.getTenantId();
        }
        return null;
    }

    public static Long getStaffIdOrNull() {
        TokenCookieDTO tokenCookieDTO = LoginUtil.get().getTokenCookie();
        if (tokenCookieDTO != null && tokenCookieDTO.getStaffId() != null) {
            return tokenCookieDTO.getStaffId();
        }
        return null;
    }

    public static Long getTenantAppIdOrNull() {
        ParamHeaderDTO paramCookie = LoginUtil.get().getParamHeader();
        if (paramCookie != null && paramCookie.getTenantAppId() != null) {
            return paramCookie.getTenantAppId();
        }
        return null;
    }

    private static class HttpRequestDto {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private TokenCookieDTO tokenCookie;
        private ParamHeaderDTO paramHeader;

        private HttpRequestDto() {
        }

        public void init(HttpServletRequest request, HttpServletResponse response, String tku) {
            this.request = request;
            this.response = response;
            this.tokenCookie = StringUtils.isBlank((CharSequence)tku) ? null : RequestUtils.getTokenCookie(tku);
            if (this.tokenCookie == null) {
                this.tokenCookie = new TokenCookieDTO();
                this.tokenCookie.setInnerUserId(SsoContext.getLoginState().getUserId());
            }
            this.paramHeader = RequestUtils.getCookieParam(request);
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.tokenCookie != null) {
                stringBuffer.append(this.tokenCookie);
            }
            stringBuffer.append("|||||");
            if (this.paramHeader != null) {
                stringBuffer.append(this.paramHeader);
            }
            stringBuffer.append("-----");
            stringBuffer.append(this.request.getHeader("manage-local"));
            return stringBuffer.toString();
        }

        public TokenCookieDTO getTokenCookie() {
            return this.tokenCookie;
        }

        public ParamHeaderDTO getParamHeader() {
            return this.paramHeader;
        }
    }
}

