/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.config;

import cn.com.duiba.cloud.manage.service.sdk.handler.MgtAuthorityHandler;
import cn.com.duiba.cloud.manage.service.sdk.handler.MgtRightsHandler;
import cn.com.duiba.cloud.manage.service.sdk.handler.TenantAppHandler;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.impl.RemotePermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtPermissionService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"cn.com.duiba.cloud.manage.service.sdk"})
public class MgtPermissionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MgtRightsHandler mgtRightsHandler() {
        return new MgtRightsHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public MgtAuthorityHandler mgtAuthorityHandler() {
        return new MgtAuthorityHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public PermissionVerification permissionVerificationRemote(RemoteMgtPermissionService service) {
        return new RemotePermissionVerification(service);
    }

    @Bean
    @ConditionalOnProperty(prefix="duiba.mgt.open_handler", value={"app"}, havingValue="true", matchIfMissing=true)
    public TenantAppHandler tenantAppHandler() {
        return new TenantAppHandler();
    }
}

