package cn.com.duiba.cloud.manage.service.api.config;

import cn.com.duiba.cloud.biz.tool.utils.PropertiesUtil;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.StringRedisSerializer;

import java.io.Serializable;
import java.time.Duration;

/**
 * @program: duiba-manage-service
 * @description: 使用Redis缓存
 * @author: 郭云龙
 * @create: 2022-03-04 10:43
 **/

@Configuration
@EnableCaching
//配置了sign.cache.redis.enable=true则开启Redis缓存
@ConditionalOnProperty(prefix = "sign.cache",name = "type",havingValue = "redis")
public class SignRedisCacheConfig implements Serializable {

    /**
     * 设置Redis缓存管理器
     * @param redisConnectionFactory
     * @return
     */
    @Bean
    public RedisCacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        return new RedisCacheManager(
                RedisCacheWriter.nonLockingRedisCacheWriter(
                        redisConnectionFactory)
                , this.getRedisCacheConfigurationWithTtl(60)//Integer.MAX_VALUE
        );
    }

    private RedisCacheConfiguration getRedisCacheConfigurationWithTtl(Integer seconds) {

        RedisCacheConfiguration defaultConfig = RedisCacheConfiguration.defaultCacheConfig()
                .computePrefixWith(
                        cacheName ->PropertiesUtil.getInstance().getProperty("spring.application.name")
                                    .concat(":").concat(cacheName).concat(":"))
                .disableCachingNullValues()
                .serializeKeysWith(RedisSerializationContext
                        .SerializationPair
                        .fromSerializer(new StringRedisSerializer()))
                .serializeValuesWith(RedisSerializationContext
                        .SerializationPair
                        .fromSerializer(new Hessian2SerializationRedisSerializer()))
                .entryTtl(Duration.ofSeconds(seconds));


        return defaultConfig;
    }


}
