package cn.com.duiba.cloud.manage.service.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.service.SignService;
import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @program: duiba-manage-service
 * @description: 签名工作类
 * @author: 郭云龙
 * @create: 2022-03-03 17:45
 **/
@Component
public class SignUtil implements ApplicationContextAware {

    private static SignService signService;

    public static String sign(Map<String,Object> map,String appKey){
        try {
            String data = JSON.toJSONString(map, SerializerFeature.MapSortField);
            data += signService.getAppSecret(appKey);
            return DigestUtil.md5Hex(data).toUpperCase();
        } catch (BizException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static boolean signCheck(Map<String,Object> map,String appKey,String sign){
        return sign.equals(sign(map, appKey));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SignUtil.signService = applicationContext.getBean(SignService.class);
    }
}
