/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.config;

import cn.com.duiba.cloud.biz.tool.utils.PropertiesUtil;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import java.io.Serializable;
import java.time.Duration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
@ConditionalOnProperty(prefix="sign.cache", name={"type"}, havingValue="redis")
public class SignRedisCacheConfig
implements Serializable {
    @Bean
    public RedisCacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        return new RedisCacheManager(RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), this.getRedisCacheConfigurationWithTtl(60));
    }

    private RedisCacheConfiguration getRedisCacheConfigurationWithTtl(Integer seconds) {
        RedisCacheConfiguration defaultConfig = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(cacheName -> PropertiesUtil.getInstance().getProperty("spring.application.name").concat(":").concat(cacheName).concat(":")).disableCachingNullValues().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Hessian2SerializationRedisSerializer())).entryTtl(Duration.ofSeconds(seconds.intValue()));
        return defaultConfig;
    }
}

