package cn.com.duiba.cloud.manage.service.api.config;

import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.util.Arrays;

/**
 * @program: duiba-manage-service
 * @description: 审核配置
 * @author: 郭云龙
 * @create: 2021-11-16 17:21
 **/


@Configuration
@EnableCaching
@ConditionalOnProperty(prefix = "sign.cache",name = "type",havingValue = "simple")
public class SignSimpleCacheConfig {

    @Bean
    @Primary
    public CacheProperties getCacheProperties(){
        CacheProperties cacheProperties = new CacheProperties();
        cacheProperties.setCacheNames(Arrays.asList(new String[]{"appSecret"}));
        return cacheProperties;
    }

}
