/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.zhongyan.goods.center.api.util;

import cn.com.duiba.cloud.zhongyan.goods.center.api.constant.SnapshotTypeEnum;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.AbstractGoodsDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.GoodsDetailDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.GoodsDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.GoodsSnapshotDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.SpuDto;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.Labels;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GoodsSnapshotUtil {
    public static final String LABEL_SNAPSHOT = "snapshot";
    public static final String LABEL_TENANT = "tenant";
    public static final String LABEL_SUPPLIER = "supplier";
    private static final String SPLIT = "@";

    public static GoodsSnapshotDto convert4Tenant(GoodsDto goodsDto) {
        SpuDto spuDto = goodsDto.getSpuDto();
        GoodsDetailDto detail = spuDto.getDetail();
        return new GoodsSnapshotDto(spuDto.getId(), detail.getUserId(), detail.getGmtModified(), SnapshotTypeEnum.TENANT, GoodsSnapshotUtil.getTenantSnapshotStr(goodsDto));
    }

    public static GoodsSnapshotDto convert4Supplier(GoodsDto goodsDto) {
        SpuDto spuDto = goodsDto.getSpuDto();
        return new GoodsSnapshotDto(spuDto.getId(), spuDto.getUserId(), spuDto.getGmtModified(), SnapshotTypeEnum.SUPPLIER, GoodsSnapshotUtil.getSupplierSnapshotStr(goodsDto));
    }

    public static String getSupplierSnapshotStr(GoodsDto goodsDto) {
        return JSON.toJSONString((Object)goodsDto, (SerializeFilter)Labels.includes((String[])new String[]{LABEL_SNAPSHOT, LABEL_SUPPLIER}), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String getTenantSnapshotStr(GoodsDto goodsDto) {
        return JSON.toJSONString((Object)goodsDto, (SerializeFilter)Labels.includes((String[])new String[]{LABEL_SNAPSHOT, LABEL_TENANT}), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String getSnapshotId(GoodsDto goodsDto) {
        GoodsSnapshotDto convert4Supplier = GoodsSnapshotUtil.convert4Supplier(goodsDto);
        GoodsSnapshotDto convert4Tenant = GoodsSnapshotUtil.convert4Tenant(goodsDto);
        return GoodsSnapshotUtil.combineSnapshot(convert4Supplier.getSnapshotId(), convert4Tenant.getSnapshotId());
    }

    private static Long getDateSecondStr(Date date) {
        return date.getTime() / 1000L;
    }

    public static void assembleGoods(GoodsDto destGoodsDto, String supplierSnapshotStr, String tenantSnapshotStr, Long skuId) {
        GoodsDto supplierSnapshotDto = (GoodsDto)JSONObject.parseObject((String)supplierSnapshotStr, GoodsDto.class);
        GoodsDto tenantSnapshotDto = (GoodsDto)JSONObject.parseObject((String)tenantSnapshotStr, GoodsDto.class);
        BeanUtils.copy((Object)supplierSnapshotDto, (Object)destGoodsDto);
        if (skuId != null) {
            destGoodsDto.setSkuList(destGoodsDto.getSkuList().stream().filter(skuDto -> Objects.equals(skuDto.getId(), skuId)).collect(Collectors.toList()));
        }
        ArrayList dest = Lists.newArrayList((Object[])new AbstractGoodsDto[]{destGoodsDto.getSpuDto()});
        dest.addAll(destGoodsDto.getSkuList());
        ArrayList source = Lists.newArrayList((Object[])new AbstractGoodsDto[]{tenantSnapshotDto.getSpuDto()});
        source.addAll(tenantSnapshotDto.getSkuList());
        Map generalKeyMap = source.stream().collect(Collectors.toMap(GeneralBiz::generalKey, Function.identity()));
        for (AbstractGoodsDto dto : dest) {
            AbstractGoodsDto abstractGoodsDto = (AbstractGoodsDto)generalKeyMap.get(dto.generalKey());
            if (abstractGoodsDto == null) continue;
            dto.setDetail(abstractGoodsDto.getDetail());
            dto.setImageList(abstractGoodsDto.getImageList());
        }
    }

    public static Pair<String, String> splitSnapshot(String snapshotId) {
        String[] split = snapshotId.split(SPLIT);
        return Pair.from((Object)split[0], (Object)split[1]);
    }

    private static String combineSnapshot(String supplierSnapshotId, String tenantSnapshotId) {
        return supplierSnapshotId + SPLIT + tenantSnapshotId;
    }

    public static String combineSnapshot(GoodsSnapshotDto supplierSnapshotId, GoodsSnapshotDto tenantSnapshotId) {
        return supplierSnapshotId.getSnapshotId() + SPLIT + tenantSnapshotId.getSnapshotId();
    }
}

