package cn.com.duiba.cloud.zhongyan.order.service.api.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuanhongjian
 */
@Getter
@AllArgsConstructor
public enum EmsDeliverGoodsTaskStateEnum {
    /**
     * 任务状态1:完成,2:处理中,3:失败
     */
    SUCCESS(1, "完成"),
    PROCESSING(2, "处理中"),
    FAILURE(3, "失败");

    private static final ImmutableMap<Integer, EmsDeliverGoodsTaskStateEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, EmsDeliverGoodsTaskStateEnum> builder = ImmutableMap
                                                                                  .builder();
        for (EmsDeliverGoodsTaskStateEnum item : EmsDeliverGoodsTaskStateEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final Integer code;
    private final String desc;

    public static EmsDeliverGoodsTaskStateEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
