package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 新增中烟发件人地址
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CreateAddressLibraryParam implements Serializable {

    private static final long serialVersionUID = 4345060787848123662L;

    /**
     * 联系人
     */
    @NotBlank(message = "联系人不能为空")
    @Size(max = 50, message = "联系人最大50个字符")
    private String userName;

    /**
     * 联系方式
     */
    @NotBlank(message = "联系方式不能为空")
    @Size(max = 20, message = "联系方式最大20个字符")
    private String phone;

    /**
     * 省
     */
    @NotNull(message = "省不能为空")
    private String province;

    /**
     * 市
     */
    @NotNull(message = "市不能为空")
    private String city;

    /**
     * 区
     */
    @NotNull(message = "区不能为空")
    private String area;

    /**
     * 详细地址
     */
    @NotNull(message = "详细地址不能为空")
    @Size(message = "详细地址不能超过100字符")
    private String addressDetail;

    /**
     * 备注
     */
    @Size(message = "备注不能超过100字符")
    private String remarks;

    /**
     * 是否默认地址
     */
    private Integer isDefault;
}
