package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 商品信息
 * @Author dangcang
 * @Date 2021/11/10 2:02 下午
 **/
@Data
public class GoodsParam implements Serializable {

    private static final long serialVersionUID = -3367088637140958493L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 商品类型
     * @see SpuTypeEnum
     */
    private Integer goodsType;

    /**
     * 商品所有人类型
     */
    private Integer ownType;

    /**
     * 商品所有人id
     */
    private Long ownId;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * 商品来源：自有商品 自有供应商 兑吧商品
     */
    private Integer goodsSource;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 销售价格 分
     */
    private Long salePrice;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 备注
     */
    private String remark;

}