package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 更新地址
 *
 * @author xuanhongjian
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UpdateAddressLibraryParam implements Serializable {

    private static final long serialVersionUID = 4071327651485968934L;

    /**
     * ID
     */
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 联系人
     */
    @Size(max = 50, message = "联系人最大50个字符")
    private String userName;

    /**
     * 联系方式
     */
    @Size(max = 20, message = "联系方式最大20个字符")
    private String phone;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;

    /**
     * 详细地址
     */
    @Size(message = "详细地址不能超过100字符")
    private String addressDetail;

    /**
     * 备注
     */
    @Size(message = "备注不能超过100字符")
    private String remarks;

    private Integer isDefault;
}
