package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 订单详情
 * @Author dangcang
 * @Date 2021/11/10 5:50 下午
 **/
@Data
public class OrderDetailDTO implements Serializable {

    private static final long serialVersionUID = 452659024024576399L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private Long bizId;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 商品信息
     */
    private List<SubOrderDetailDTO> subOrderDetailDTOS;

    /**
     * 收货人信息
     */
    private ReceiverUserDTO receiverUserDTO;

    /**
     * 扩展信息查询
     */
    private List<OrderExtraDTO> orderExtraDTOS;

}