package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import cn.com.duiba.wolf.entity.PageRequest;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class QueryEmsDeliverTaskParam extends PageRequest {

    private static final long serialVersionUID = 4101507163789567986L;

    /**
     * 操作开始时间
     */
    private Date operateStartDate;

    /**
     * 操作结束时间
     */
    private Date operateEndDate;

    /**
     * 任务状态 1:完成,2:处理中,3:失败 {@link cn.com.duiba.cloud.zhongyan.order.service.api.enums.EmsDeliverGoodsTaskStateEnum}
     */
    private Integer taskState;

    /**
     * 操作人
     */
    private String userName;

    /**
     * 操作人id 查询
     */
    private String userId;
}
