package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @author xuanhongjian
 */
@Data
public class ExportEmsDeliverGoodsParam implements Serializable {

    private static final long serialVersionUID = 369989076992658429L;
    /**
     * 下单开始时间
     */
    @NotNull(message = "下单时间不能为空")
    private Date createOrderStartDate;

    /**
     * 下单结束时间
     */
    @NotNull(message = "下单时间不能为空")
    private Date createOrderEndDate;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;

    /**
     * 浙江省外
     */
    private Integer notZheJiang;

    /**
     * 发货开始时间
     */
    private Date deliveryStartDate;

    /**
     * 发货结束时间
     */
    private Date deliveryEndDate;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单编号
     */
    private List<String> orderCodes;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 收件人手机号
     */
    private String phone;

    /**
     * 收件人
     */
    private Long buyerId;

    /**
     * 排序字段 {@link cn.com.duiba.cloud.zhongyan.order.service.api.enums.SortEnum}
     */
    private String sortRule;

    /**
     * 发货状态 {@link cn.com.duiba.cloud.zhongyan.order.service.api.enums.EmsDeliverGoodsStateEnum}
     */
    private Integer deliverGoodsState;


    private Long batchId;

    /**
     * 租户id
     */
    @NotNull(message = "租户id不能为空")
    private Long tenantId;

    /**
     * 用户id
     */
    @NotNull(message = "用户id不能为空")
    private Long innerUserId;
}
