package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import cn.com.duiba.cloud.zhongyan.order.service.api.enums.OrderTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 创建订单
 * @Author dangcang
 * @Date 2021/11/10 1:57 下午
 **/
@Data
public class OrderCreateParam implements Serializable {

    private static final long serialVersionUID = 1260557828431632752L;
    /**
     * 订单类型
     * @see OrderTypeEnum
     */
    private Integer orderType;

    /**
     * 地址id
     */
    private Long addressId;

    /**
     * 来源 和orderType确定
     */
    private Long orderSourceId;

    /**
     * 用户信息相关
     */
    private UserParam userParam;

    /**
     * 商品相关
     */
    private List<GoodsParam> goodsParams;
}