package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

/**
 * @Description 订单查询参数
 * @Author dangcang
 * @Date 2021/11/10 3:05 下午
 **/
@Getter
@Setter
public class OrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 8035926659649749486L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家id 列表
     */
    private Set<Long> buyerIds;

    /**
     * 买家类型
     */
    private Integer buyerType;

    /**
     * 下单开始时间 毫秒级时间戳
     */
    private Date orderStartTime;

    /**
     * 下单截止时间 毫秒级时间戳
     */
    private Date orderEndTime;

    /**
     * 订单来源
     * 等价数据库 bizId
     */
    @Deprecated
    private Long OrderSource;

    /**
     * 业务id bizId
     */
    private Long bizId;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品来源
     */
    private Long goodsSource;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 第三方skuId
     */
    private String thirdSkuId;
}