package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class QueryEmsDeliverGoodsCountParam implements Serializable {

    private static final long serialVersionUID = -5434260206312677842L;

    /**
     * 下单开始时间
     */
    private Date createOrderStartDate;

    /**
     * 下单结束时间
     */
    private Date createOrderEndDate;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;

    /**
     * 浙江省外
     */
    private Integer notZheJiang;

    /**
     * 发货开始时间
     */
    private Date deliveryStartDate;

    /**
     * 发货结束时间
     */
    private Date deliveryEndDate;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 收件人手机号
     */
    private String phone;

    /**
     * 收件人
     */
    private Long buyerId;
}
