/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.zhongyan.order.service.api.enums;

import java.util.HashMap;
import java.util.Map;

public enum OrderStatusEnum {
    WAIT_COMPLETION(1, "\u5f85\u5b8c\u6210"),
    WAIT_PAY(10, "\u5f85\u652f\u4ed8"),
    WAIT_REVIEW(20, "\u5f85\u5ba1\u6838"),
    WAIT_SHIPMENT(30, "\u5f85\u53d1\u8d27"),
    WAIT_TAKE_DELIVERY(40, "\u5f85\u6536\u8d27"),
    ORDER_COMPLETION(50, "\u4ea4\u6613\u5b8c\u6210"),
    ORDER_ERROR(89, "\u5f02\u5e38\u72b6\u6001"),
    ORDER_SUCCESS(90, "\u4ea4\u6613\u6210\u529f"),
    ORDER_CLOSE(91, "\u4ea4\u6613\u5173\u95ed");

    private Integer status;
    private String desc;
    private static Map<Integer, OrderStatusEnum> map;
    private static Map<String, OrderStatusEnum> descMap;

    private OrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static OrderStatusEnum getByStatus(Integer status) {
        return map.get(status);
    }

    public static OrderStatusEnum getByDesc(String desc) {
        return descMap.get(desc);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        map = new HashMap<Integer, OrderStatusEnum>(){
            {
                for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
                    this.put(statusEnum.getStatus(), statusEnum);
                }
            }
        };
        descMap = new HashMap<String, OrderStatusEnum>(){
            {
                for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
                    this.put(statusEnum.getDesc(), statusEnum);
                }
            }
        };
    }
}

