package cn.com.duiba.compact.duiba.compact.api.dto;

import cn.com.duiba.compact.duiba.compact.api.constants.ReceiverType;
import cn.com.duiba.compact.duiba.compact.api.constants.UserType;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2021-01-29 11:46
 * @descript:
 * @version: 1.0
 */
@Data
public class ReceiverDto {

    /**
     * 收件账号,手机或邮箱
     */
    private String userAccount;

    /**
     * 收件方类型：个人/企业
     */
    private UserType userType = UserType.ENTERPRISE;

    /**
     * 收件方姓名,或企业经办人姓名，如果是合作方可不填
     */
    private String userName;

    /**
     * 接收方企业名称,如果签署人为个人则不填
     * <p>企业名称需与工商局注册的企业全称完全一致</p>
     */
    private String enterpriseName;

    /**
     * 临时通知手机,须使用中国大陆手机
     * 该手机可以收到合同签署通知，但不能用于签署校验
     * 非必填
     */
    private String notification;

    /**
     * 签署顺序
     * 不支持负数。signOrdered为true，则各个参与人按次序签署合同,越小优先级越高
     */
    private Integer routeOrder;

    /**
     * 参与签署或仅抄送:
     * SIGNER(签署人签署合同), CC_USER(抄送人查看合同)
     */
    private ReceiverType receiverType = ReceiverType.SIGNER;

    /**
     * 用来定位签署位置
     * 合同末尾的甲乙方盖章下面的不需要传，接口会自动加上
     */
    private List<LabelKeywordDto> labels = new ArrayList<>();
}
