package cn.com.duiba.compact.duiba.compact.api.dto;

import cn.com.duiba.compact.duiba.compact.api.constants.BusinessLineEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2021-01-28 14:17
 * @descript: 发送合同
 * @version: 1.0
 */
@Data
public class CreateContractSendDto implements Serializable {


    private static final long serialVersionUID = -8147019409639881628L;
    /**
     * 合同标题
     * <p>不能包含【；】；[；]，否则可能会导致短信通知失败</p>
     */
    private String contractTitle;

    /**
     * 业务线
     */
    private BusinessLineEnum businessLineEnum;

    /**
     * 自定义场景编号
     */
    private String sceneBizCode;

    /**
     * 合同绑定实体的编号，如客户编号
     * 回调的bizCode格式：{businessLineEnum}-{sceneBizCode}-{bizCode}
     */
    private String bizCode;

    /**
     * 发件方
     */
    private ContractSenderDto sender;

    /**
     * 签约截止日期
     * 格式为毫秒timestamp，不能早于当前发送时间
     */
    private String signDeadline;

    /**
     * 是否顺序签署
     * <p>true表示“receiver”中的routeOrder字段生效，各个签署人是按routeOrder中的次序签署合同；false表示没有先后</p>
     */
    private boolean signOrdered = true;

    /**
     * 合同具体内容
     */
    private ContractDocumentDto document;

    /**
     * 甲方盖章信息
     */
    private ReceiverDto partyAReceiver;

    /**
     * 甲方签署人信息，如果不需要签署人签署可不传
     */
    private ReceiverDto partyASignReceiver;

    /**
     * 乙方盖章信息
     */
    private ReceiverDto partyBReceiver;

    /**
     * 乙方签署人信息，如果不需要签署人签署可不传
     */
    private ReceiverDto partyBSignReceiver;

    /**
     * 是否自签,如果自签，会使用发送方的信息自签
     */
    private Boolean isSelfSigned;

}
