package cn.com.duiba.compact.duiba.compact.api.dto;

import cn.com.duiba.compact.duiba.compact.api.constants.ReceiverType;
import cn.com.duiba.compact.duiba.compact.api.constants.UserType;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2021-01-29 11:46
 * @descript:
 * @version: 1.0
 */
@Data
public class ReceiverDto implements Serializable {


    private static final long serialVersionUID = -229115391171724627L;
    /**
     * 收件账号,手机或邮箱
     */
    private String userAccount;

    /**
     * 收件方类型：个人/企业
     */
    private UserType userType = UserType.ENTERPRISE;

    /**
     * 收件方姓名,或企业经办人姓名
     */
    private String userName;

    /**
     * 接收方企业名称,如果签署人为个人则不填
     * <p>企业名称需与工商局注册的企业全称完全一致</p>
     */
    private String enterpriseName;

    /**
     * 临时通知手机,须使用中国大陆手机
     * 该手机可以收到合同签署通知，但不能用于签署校验
     * 非必填
     */
    private String notification;

    /**
     * 签署顺序
     * 不支持负数。signOrdered为true，则各个参与人按次序签署合同,越小优先级越高
     */
    private Integer routeOrder;

    /**
     * 参与签署或仅抄送:
     * SIGNER(签署人签署合同), CC_USER(抄送人查看合同)
     */
    private ReceiverType receiverType = ReceiverType.SIGNER;

    /**
     * 合同签署链接。签署人点击后需先填写密码或验证码才能查看合同
     */
    private String shortOperateUrl;

    /**
     * ture表示必须已通过上上签实名认证的用户才能签署，仅对个人类型的SIGNER(签署人)有效，
     * CC_USER(抄送人)不做校验，企业签署人也不做校验
     */
    private Boolean requireIdentityAssurance;

    /**
     * true表示必须手写签名签署，false表示不生效。
     * 只对个人签名有效，企业盖章不做校验
     */
    private Boolean forceHandWrite;

    /**
     * 用来定位签署位置
     * 合同末尾的甲乙方盖章下面的不需要传，接口会自动加上
     */
    private List<LabelKeywordDto> labels = new ArrayList<>();
}
