package cn.com.duiba.compact.duiba.compact.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.compact.duiba.compact.api.dto.CompactStaffDto;
import cn.com.duiba.compact.duiba.compact.api.dto.CreateContractResultDto;
import cn.com.duiba.compact.duiba.compact.api.dto.CreateContractSendDto;

import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2021-01-06 15:43
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteBestSignService {

    /**
     * 发送劳动合同
     * @param compactStaffDtoList 员工信息
     * @param agentName 经办人
     * @param agentMobile 经办人手机号
     * @param companyName 签约主体
     * @return 合同编号
     */
    List<CompactStaffDto> sendLaborCompact(List<CompactStaffDto> compactStaffDtoList, String agentName, String agentMobile,
                            String companyName);

    /**
     * 创建并发送合同
     * <p>该方法为异步，如果要合同编号，监听rocketmq的回调事件</p>
     * <ul>
     *     <li>topic:bestSignCallbackTopic</li>
     *     <li>tag: CompactEventTypeEnum</li>
     *     <li>msgBody: {
     *     "timestamp":"1528079523454",//时间戳
     *     "clientId":"123545ytuu",//分配的clientId
     *     "type":"COMPLETE",//合同签署完成
     *     "responseData":{
     *         "bizNo":"",//创建合同的bizCode
     *         "contractIds":[//注意是数组
     *             11111111111111,
     *             22222222222222,
     *             33333333333333
     *         ]
     *     }
     * }</li>
     * <li>说明：该上上签接口存在延迟，如果签署方有很多，可能会超时，尽量签署方保持一个</li>
     * </ul>
     * @param sendDto
     * @return 合同编号
     */
    CreateContractResultDto sendCompact(CreateContractSendDto sendDto);
}
