package cn.com.duiba.compact.duiba.compact.api.utils;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.codec.binary.Base64;

import java.util.concurrent.TimeUnit;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2021-03-18 15:05
 * @descript: 合同文件
 * @version: 1.0
 */
public class CompactFileUtil {

    private static final OkHttpClient okHttpClient = new OkHttpClient
            .Builder()
            .readTimeout(5, TimeUnit.SECONDS)
            .build();


    /**
     * 通过url获取合同base64的内容
     *
     * @param url
     * @return
     */
    public static String getCompactContentByUrl(String url) {

        byte[] bytes = download(url);
        return encodeBase64(bytes);
    }

    /**
     * @param url 下载连接
     */
    private static byte[] download(final String url) {

        Request request = new Request.Builder().url(url).build();

        byte[] buffer = null;
        try (Response response = okHttpClient.newCall(request).execute()) {

            ResponseBody responseBody = response.body();
            if (responseBody == null || responseBody.contentLength() == 0) {
                return null;
            }

            buffer = responseBody.bytes();

        } catch (Exception e) {
            // ignore
        }

        return buffer;
    }

    /**
     * base64编码
     *
     * @param buffer
     * @return
     */
    private static String encodeBase64(byte[] buffer) {
        return Base64.encodeBase64String(buffer);
    }
}
