package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.consumer.center.api.dto.ConsumerDto;

import java.util.List;

/**
 * Created by wenqi.huang on 16/4/8.
 */
public interface RemoteConsumerService {

    public ConsumerDto find(Long consumerId);

    public List<ConsumerDto> findAllByIds(List<Long> ids);
    /**
     * 根据App和开发者用户id查询兑吧用户Consumer
     * @param appId
     * @param partnerUserId
     * @midified by zhangpan
     * @return
     */
    public ConsumerDto findByAppAndPartnerUserId(Long appId, String partnerUserId);


    /**
     * 添加一个用户
     * @param consumer
     */
    public ConsumerDto insert(ConsumerDto consumer);

    /**
     * 更新用户积分，主要用在自动登录处
     * @param consumerId
     * @param credits
     * @midified by zhangpan
     */
    public int updateCredits(Long consumerId, Long credits);
    /**
     * 用户积分进行增加
     * @param consumerId
     * @param credits
     * @midified by zhangpan
     */
    public int increaseCredits(Long consumerId, Long credits);
    /**
     * 用户积分进行减少
     * @param consumerId
     * @param credits
     * @midified by zhangpan
     */
    public int decrementCredits(Long consumerId, Long credits);

    public int updateAutologinParams(Long consumerId, Long credits, String alipay, String qq, String phone, Integer vipLevel);

    public int updateUnreadCount(Long consumerId, int count);
    /**
     * 更新最近一次填写的支付宝信息
     * @param consumerId
     * @param lastAlipay
     * @param lastRealname
     * @return
     */
    public int updateLastAlipay(Long consumerId, String lastAlipay, String lastRealname);

    /**
     * 更新最近一次填写的收货信息
     * @param consumerId
     * @param addrName
     * @param addrProvince
     * @param addrCity
     * @param addrArea
     * @param addrDetail
     * @param addrPhone
     * @return
     */
    public int updateAddress(Long consumerId, String addrName, String addrProvince, String addrCity, String addrArea,
                             String addrDetail, String addrPhone);
    /**
     * 更新用户最后一次填写号码
     * @param consumerId
     * @param lastPhone
     * @return
     */
    public int updateLastPhone(Long consumerId, String lastPhone);
    /**
     * 更新最后一次填写的QQ
     * @param consumerId
     * @param lastQq
     * @return
     */
    public int updateLastQq(Long consumerId, String lastQq);
}
