package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.DuibaTrusteeshipUserImportRecordDto;
import cn.com.duiba.consumer.center.api.paramQuery.trusteeshipuser.RecordParam;

import java.util.List;

/**
 * @author haojiahong
 * @date 2022-09-22
 */
@AdvancedFeignClient
public interface RemoteDuibaTrusteeshipUserImportRecordService {

    /**
     * 通过条件查询记录，只展示最近100条
     *
     * @param param
     * @return
     */
    List<DuibaTrusteeshipUserImportRecordDto> findListByCondition(RecordParam param);

    /**
     * 通过条件查询总记录数，只展示最近100条
     *
     * @param param
     * @return
     */
    Integer countByCondition(RecordParam param);

    /**
     * 通过文件名查询记录
     *
     * @param appId
     * @param fileName
     * @return
     */
    DuibaTrusteeshipUserImportRecordDto findByFileName(Long appId, String fileName);


    /**
     * 保存
     *
     * @param recordDto
     * @return
     */
    Integer save(DuibaTrusteeshipUserImportRecordDto recordDto);


}
