package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.DuibaTrusteeshipUserDto;
import cn.com.duiba.consumer.center.api.paramQuery.trusteeshipuser.UserParam;

import java.util.List;

/**
 * @author haojiahong
 * @date 2022-09-22
 */
@AdvancedFeignClient
public interface RemoteDuibaTrusteeshipUserService {

    /**
     * 查询初始用户（还未登录到兑吧）
     *
     * @param appId
     * @param uid
     * @return
     */
    DuibaTrusteeshipUserDto findInitUserByAppIdUid(Long appId, String uid);

    /**
     * 对初始用户完成初始化
     * 免登后调用处理
     *
     * @param trusteeshipUserDto
     * @return
     */
    Boolean completeInitUser(DuibaTrusteeshipUserDto trusteeshipUserDto);


    List<DuibaTrusteeshipUserDto> findListByCondition(UserParam param);

    Integer countByCondition(UserParam param);

    /**
     * 完成初始化，记录consumerId
     * 【免登时调用】
     * 若未导入用户，则插入新记录
     * 若已导入用户，则更新consumerId，同步等级、积分
     *
     * @param appId
     * @param uid
     * @param consumerId
     * @param userLevel
     * @param userCredits
     * @return
     */
    Boolean initUser(Long appId, String uid, Long consumerId, Integer userLevel, Long userCredits);


    /**
     * 加积分
     * 【加积分后调用】
     *
     * @param appId
     * @param uid
     * @param credits
     * @return
     */
    Boolean addCredits(Long appId, String uid, Long credits);

    /**
     * 减积分
     * 【减积分后调用】
     *
     * @param appId
     * @param uid
     * @param credits
     * @return
     */
    Boolean subCredits(Long appId, String uid, Long credits);


    /**
     * 批量导入加积分
     * 只需处理未初始化用户，已初始化用户加积分会同步
     *
     * @param list
     * @return
     */
    Boolean importAdd(List<DuibaTrusteeshipUserDto> list);

    /**
     * 批量导入减积分
     * 只需处理未初始化用户，已初始化用户减积分会同步
     *
     * @param list
     * @return
     */
    Boolean importSub(List<DuibaTrusteeshipUserDto> list);

}
