package cn.com.duiba.consumer.center.api.dto;

import cn.com.duiba.api.enums.ItemTypeEnums;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.*;

/**
 * Created by zhengjy on 2016/12/26.
 */
public class ConsumerFootprintDto implements Serializable {
    private static final long serialVersionUID = 4168430074071754832L;

    private Long                           id;

    private Long                           consumerId;

    private String                         phonebill;

    private String                         phoneflow;

    private String                         qb;

    private String                         alipay;

    private String                         alipaycard;

    private String                         alipaycode;

    private String                         coupon;

    private String                         object;

    private String                         gamecard;

    private String                         virtual;

    private String                         phonebillDingzhi;

    private Date gmtCreate;

    private Date                           gmtModified;

    private Map<String, List<FootprintDto>> json;

    /**
     *
     */
    public ConsumerFootprintDto() {
    }

    /**
     *
     * @param id
     */
    public ConsumerFootprintDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     *
     * @param init4insert
     */
    public ConsumerFootprintDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }


    public List<FootprintDto> getPhonebillDingzhiToArray() {
        return getFootprints(phonebillDingzhi);
    }

    public List<FootprintDto> getPhonebillToArray() {
        return getFootprints(phonebill);
    }

    public List<FootprintDto> getPhoneflowToArray() {
        return getFootprints(phoneflow);
    }

    public List<FootprintDto> getQbToArray() {
        return getFootprints(qb);
    }

    public List<FootprintDto> getAlipayToArray() {
        return getFootprints(alipay);
    }

    public List<FootprintDto> getAlipaycardToArray() {
        return getFootprints(alipaycard);
    }

    public List<FootprintDto> getAlipaycodeToArray() {
        return getFootprints(alipaycode);
    }

    public List<FootprintDto> getCouponToArray() {
        return getFootprints(coupon);
    }

    public List<FootprintDto> getObjectToArray() {
        return getFootprints(object);
    }

    public List<FootprintDto> getGamecardToArray() {
        return getFootprints(gamecard);
    }

    public List<FootprintDto> getVirtualToArray() {
        return getFootprints(virtual);
    }

    public static String getColumnByType(String type) {
        if (ItemTypeEnums.TypePhonebill.getName().equals(type)) {
            return "phonebill";
        } else if (ItemTypeEnums.TypePhoneflow.getName().equals(type)) {
            return "phoneflow";
        } else if (ItemTypeEnums.TypeQB.getName().equals(type)) {
            return "qb";
        } else if (ItemTypeEnums.TypeAlipay.getName().equals(type)) {
            return "alipay";
        } else if (ItemTypeEnums.TypeAlipayFast.getName().equals(type)) {
            return "alipaycard";
        } else if (ItemTypeEnums.TypeAlipayCode.getName().equals(type)) {
            return "alipaycode";
        } else if (ItemTypeEnums.TypeCoupon.getName().equals(type)) {
            return "coupon";
        } else if (ItemTypeEnums.TypeObject.getName().equals(type)) {
            return "object";
        } else if (ItemTypeEnums.TypeGameCard.getName().equals(type)) {
            return "gamecard";
        } else if (ItemTypeEnums.TypeVirtual.getName().equals(type)) {
            return "virtual";
        } else if (ItemTypeEnums.TypePhonebillDingzhi.getName().equals(type)) {
            return "phonebillDingzhi";
        }
        return null;
    }

    /**
     *
     * @param type
     * @return
     */
    public List<FootprintDto> getColumnDataByType(String type) {
        if (ItemTypeEnums.TypePhonebill.getName().equals(type)) {
            return getPhonebillToArray();
        } else if (ItemTypeEnums.TypePhoneflow.getName().equals(type)) {
            return getPhoneflowToArray();
        } else if (ItemTypeEnums.TypeQB.getName().equals(type)) {
            return getQbToArray();
        } else if (ItemTypeEnums.TypeAlipay.getName().equals(type)) {
            return getAlipayToArray();
        } else if (ItemTypeEnums.TypeAlipayFast.getName().equals(type)) {
            return getAlipaycardToArray();
        } else if (ItemTypeEnums.TypeAlipayCode.getName().equals(type)) {
            return getAlipaycodeToArray();
        } else if (ItemTypeEnums.TypeCoupon.getName().equals(type)) {
            return getCouponToArray();
        } else if (ItemTypeEnums.TypeObject.getName().equals(type)) {
            return getObjectToArray();
        } else if (ItemTypeEnums.TypeGameCard.getName().equals(type)) {
            return getGamecardToArray();
        } else if (ItemTypeEnums.TypeVirtual.getName().equals(type)) {
            return getVirtualToArray();
        } else if (ItemTypeEnums.TypePhonebillDingzhi.getName().equals(type)) {
            return getPhonebillDingzhiToArray();
        }
        return Collections.emptyList();
    }

    /**
     *
     * @param type
     * @param footprints
     */
    public void setColumnByType(String type, List<FootprintDto> footprints) {
        if (ItemTypeEnums.TypePhonebill.getName().equals(type)) {
            setPhonebill(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypePhoneflow.getName().equals(type)) {
            setPhoneflow(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeQB.getName().equals(type)) {
            setQb(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeAlipay.getName().equals(type)) {
            setAlipay(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeAlipayFast.getName().equals(type)) {
            setAlipaycard(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeAlipayCode.getName().equals(type)) {
            setAlipaycode(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeCoupon.getName().equals(type)) {
            setCoupon(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeObject.getName().equals(type)) {
            setObject(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeGameCard.getName().equals(type)) {
            setGamecard(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypeVirtual.getName().equals(type)) {
            setVirtual(JSON.toJSONString(footprints));
        } else if (ItemTypeEnums.TypePhonebillDingzhi.getName().equals(type)) {
            setPhonebillDingzhi(JSON.toJSONString(footprints));
        }
    }

    private List<FootprintDto> getFootprints(String column) {
        if (StringUtils.isEmpty(column)) {
            return Lists.newArrayList();
        }
        if (json == null) {
            json = Maps.newHashMap();
        }
        List<FootprintDto> footprint;
        if (json.get(column) == null) {
            footprint = JSON.parseArray(column, FootprintDto.class);
            json.put(column, footprint);
        } else {
            footprint = json.get(column);
        }
        return footprint;
    }

    /**** setters and getters ***********************/

    public void setId(Long id) {
        this.id = id;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public void setPhonebill(String phonebill) {
        this.phonebill = phonebill;
    }

    public void setPhoneflow(String phoneflow) {
        this.phoneflow = phoneflow;
    }

    public void setQb(String qb) {
        this.qb = qb;
    }

    public void setAlipay(String alipay) {
        this.alipay = alipay;
    }

    public void setAlipaycard(String alipaycard) {
        this.alipaycard = alipaycard;
    }

    public void setAlipaycode(String alipaycode) {
        this.alipaycode = alipaycode;
    }

    public void setCoupon(String coupon) {
        this.coupon = coupon;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setVirtual(String virtual) {
        this.virtual = virtual;
    }

    public void setGamecard(String gamecard) {
        this.gamecard = gamecard;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getPhonebill() {
        return phonebill;
    }

    public String getPhoneflow() {
        return phoneflow;
    }

    public String getQb() {
        return qb;
    }

    public String getAlipay() {
        return alipay;
    }

    public String getAlipaycard() {
        return alipaycard;
    }

    public String getAlipaycode() {
        return alipaycode;
    }

    public String getCoupon() {
        return coupon;
    }

    public String getObject() {
        return object;
    }

    public String getGamecard() {
        return gamecard;
    }

    public String getVirtual() {
        return virtual;
    }

    public Long getId() {
        return id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public String getPhonebillDingzhi() {
        return phonebillDingzhi;
    }

    public void setPhonebillDingzhi(String phonebillDingzhi) {
        this.phonebillDingzhi = phonebillDingzhi;
    }
}
