package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ConsumerUserTagDto;

import java.util.List;

/**
 * 用户标签
 *
 * @author haojiahong
 * @date 2022-10-21
 */
@AdvancedFeignClient
public interface RemoteConsumerUserTagService {

    /**
     * 更新用户标签
     *
     * @param consumerId
     * @param tagCodeList
     * @return
     */
    Boolean refresh(Long consumerId, List<String> tagCodeList);

    /**
     * 获取用户拥有的标签
     *
     * @param consumerId
     * @return
     */
    List<ConsumerUserTagDto> findUserTags(Long consumerId);

}
