package cn.com.duiba.consumer.center.api.enums;

/**
 * 性别枚举
 * Created by xiaoxuda on 2017/3/9.
 */
public enum SexTypeEnum {
    MAN(1,"男"),
    WOMAN(2,"女");

    private Integer type;
    private String desc;

    SexTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static SexTypeEnum getByType(Integer type){
        for(SexTypeEnum typeEnum : values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
