package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.consumer.center.api.dto.ConsumerExtraDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 用户额外信息接口
 * Created by xiaoxuda on 2017/03/09.
 */
public interface RemoteConsumerExtraService {

    /**
     * 通过ID查询
     * @param id
     * @return
     */
    DubboResult<ConsumerExtraDto> findById(Long id);

    /**
     * 通过consumerId查询
     * @param consumerId
     * @return
     */
    DubboResult<ConsumerExtraDto> findByConsumerId(Long consumerId);

    /**
     * 通过consumerId批量查询
     * @param consumerIds
     * @return
     */
    DubboResult<List<ConsumerExtraDto>> findAllByConsumerIds(List<Long> consumerIds);

    /**
     * 保存
     * @param consumerExtraDto
     */
    DubboResult<ConsumerExtraDto> insert(ConsumerExtraDto consumerExtraDto);

    /**
     * 通过ID更新数据
     * @param consumerExtraDto
     * @return
     */
    DubboResult<Integer> updateById(ConsumerExtraDto consumerExtraDto);
}
