/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.bo.impl;

import cn.com.duiba.consumer.center.api.dto.AppSignConfigDto;
import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.consumer.center.api.dto.ConsumerSignInfoDto;
import cn.com.duiba.consumer.center.api.dto.SignLogDto;
import cn.com.duiba.consumer.center.api.dto.SignRecordDto;
import cn.com.duiba.consumer.center.api.dto.SignResultDto;
import cn.com.duiba.consumer.center.api.params.AppSignConfigParams;
import cn.com.duiba.consumer.center.api.params.SignLogParams;
import cn.com.duiba.consumer.center.api.params.SignParams;
import cn.com.duiba.consumer.center.biz.bo.SignSystemBo;
import cn.com.duiba.consumer.center.biz.bo.sign.CircleSignHandler;
import cn.com.duiba.consumer.center.biz.bo.sign.ContinueSignHandler;
import cn.com.duiba.consumer.center.biz.bo.sign.CustomSignHandler;
import cn.com.duiba.consumer.center.biz.bo.sign.SignHandler;
import cn.com.duiba.consumer.center.biz.entity.sign.SignConfigEntity;
import cn.com.duiba.consumer.center.biz.exception.BiznessException;
import cn.com.duiba.consumer.center.biz.exception.CodeRuntimeException;
import cn.com.duiba.consumer.center.biz.service.ConsumerService;
import cn.com.duiba.consumer.center.biz.service.SignConfigService;
import cn.com.duiba.consumer.center.biz.service.SignLogService;
import cn.com.duiba.consumer.center.biz.service.SignRecordService;
import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SignSystemBoImpl
implements SignSystemBo,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SignSystemBoImpl.class);
    @Autowired
    private SignRecordService signRecordService;
    @Autowired
    private SignConfigService signConfigService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private SignLogService signLogService;
    @Autowired
    private RemoteIDMakerService remoteIDMakerService;
    private ApplicationContext applicationContext;
    private Joiner jion = Joiner.on((String)",").skipNulls();

    @Override
    public Long createSignLog(SignLogParams params) {
        DubboResult logIdRes = this.remoteIDMakerService.getNextID(IDMakerTypeEnums.SIGN_IN.getType());
        if (!logIdRes.isSuccess()) {
            throw new RuntimeException("\u83b7\u53d6Id\u5931\u8d25:" + logIdRes.getMsg());
        }
        SignLogDto insert = new SignLogDto();
        insert.setConsumerId(params.getConsumerId());
        insert.setCredits(params.getCredits());
        insert.setSignType(params.getSignType());
        insert.setLogId((Long)logIdRes.getResult());
        this.signLogService.insert(insert);
        return (Long)logIdRes.getResult();
    }

    @Override
    public SignResultDto doSignIn(SignParams params) throws BiznessException {
        ConsumerDto consumer = this.consumerService.find(params.getConsumerId());
        if (consumer == null) {
            throw new BiznessException("\u7b7e\u5230\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SignConfigEntity signConfig = this.signConfigService.findSignConfigByAppId(consumer.getAppId());
        if (signConfig == null) {
            throw new BiznessException("\u7b7e\u5230\u914d\u7f6e\u4e0d\u5b8c\u5584");
        }
        SignLogDto log = this.signLogService.findByLogId(params.getLogId());
        if (log == null || log.getLogStatue() != 0) {
            throw new BiznessException("\u6b64\u6b21\u7b7e\u5230\u5df2\u7ecf\u88ab\u53d7\u7406");
        }
        this.signLogService.successLog(params.getLogId(), params.getBizId());
        SignHandler handler = this.getSignHandler(signConfig.getSignType());
        SignResultDto result = handler.doSignIn(signConfig, params.getConsumerId());
        Long credits = (long)result.getCredits();
        this.consumerService.increaseCredits(params.getConsumerId(), credits);
        return result;
    }

    @Override
    public ConsumerSignInfoDto getSignInfo(Long consumerId) {
        ConsumerDto consumer = this.consumerService.find(consumerId);
        if (consumer == null) {
            return null;
        }
        SignConfigEntity signConfig = this.signConfigService.findSignConfigByAppId(consumer.getAppId());
        if (signConfig == null) {
            ConsumerSignInfoDto info = new ConsumerSignInfoDto();
            info.setConfigError(Boolean.valueOf(true));
            return info;
        }
        SignRecordDto record = this.signRecordService.findByConsumerId(consumerId);
        SignHandler handler = this.getSignHandler(signConfig.getSignType());
        if (record == null) {
            record = handler.getDefaultRecord(signConfig, consumerId);
        }
        ConsumerSignInfoDto info = handler.getConsumerSignInfoDto(signConfig, record);
        return info;
    }

    @Override
    public AppSignConfigDto getSignInConfigInfo(Long appId) {
        SignConfigEntity entity = this.signConfigService.findSignConfigByAppId(appId);
        AppSignConfigDto dto = new AppSignConfigDto();
        if (entity == null) {
            dto.setAppId(appId);
            dto.setSignType(Integer.valueOf(0));
            dto.setSignCreditsList(Collections.emptyList());
            dto.setSignInfoUrl("");
        } else {
            dto.setAppId(appId);
            dto.setSignType(entity.getSignType());
            Splitter spl = Splitter.on((String)",").omitEmptyStrings().trimResults();
            List list = spl.splitToList((CharSequence)entity.getSignCredits());
            ArrayList newList = Lists.newArrayList();
            for (String it : list) {
                newList.add(Integer.valueOf(it));
            }
            dto.setSignCreditsList((List)newList);
            if (StringUtils.isBlank((String)entity.getSignInfoUrl())) {
                dto.setSignInfoUrl("");
            } else {
                dto.setSignInfoUrl(entity.getSignInfoUrl());
            }
            dto.setSwitches(entity.getSwitches());
        }
        return dto;
    }

    @Override
    public Boolean updateSignInConfig(AppSignConfigParams params) {
        try {
            String signCredits = this.jion.join((Iterable)params.getSignCreditsList());
            SignConfigEntity entity = new SignConfigEntity();
            entity.setSignCredits(signCredits);
            entity.setSignType(params.getSignType());
            if (2 == params.getSignType()) {
                entity.setSignInfoUrl(params.getSignInfoUrl());
            }
            entity.setAppId(params.getAppId());
            this.signConfigService.saveSignConfig(entity);
            return true;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58App\u7b7e\u5230\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean setSignLogStatue(Long logId, Integer signStatue) {
        SignLogDto dto = this.signLogService.findByLogId(logId);
        if (dto == null || dto.getLogStatue() != 0) {
            return false;
        }
        this.signLogService.updateLogStatue(logId, signStatue);
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private SignHandler getSignHandler(Integer signType) {
        switch (signType) {
            case 0: {
                return (SignHandler)this.applicationContext.getBean(ContinueSignHandler.class);
            }
            case 1: {
                return (SignHandler)this.applicationContext.getBean(CircleSignHandler.class);
            }
            case 2: {
                return (SignHandler)this.applicationContext.getBean(CustomSignHandler.class);
            }
        }
        throw new CodeRuntimeException("\u7b7e\u5230\u7b56\u7565\u7c7b\u578b\u5f02\u5e38");
    }
}

