/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.bo.sign;

import cn.com.duiba.consumer.center.api.dto.ConsumerSignInfoDto;
import cn.com.duiba.consumer.center.api.dto.SignRecordDto;
import cn.com.duiba.consumer.center.api.dto.SignResultDto;
import cn.com.duiba.consumer.center.biz.bo.sign.SignHandler;
import cn.com.duiba.consumer.center.biz.entity.sign.SignConfigEntity;
import cn.com.duiba.consumer.center.biz.exception.BiznessException;
import cn.com.duiba.consumer.center.biz.service.SignRecordService;
import cn.com.duiba.consumer.center.biz.support.DateUtils;
import com.google.common.base.Splitter;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CircleSignHandler
extends SignHandler {
    @Autowired
    private SignRecordService signRecordService;
    private Splitter spl = Splitter.on((String)",").trimResults().omitEmptyStrings();

    @Override
    public ConsumerSignInfoDto getConsumerSignInfoDto(SignConfigEntity signConfig, SignRecordDto record) {
        ConsumerSignInfoDto info = new ConsumerSignInfoDto();
        info.setSignType(Integer.valueOf(1));
        if (StringUtils.isBlank((String)signConfig.getSignCredits())) {
            info.setConfigError(Boolean.valueOf(true));
            return info;
        }
        Date now = new Date();
        Date lastSignTime = record.getEndSignDay();
        int signDay = this.isContinuous(signConfig, record) != false ? record.getSignDay() : 0;
        info.setSignDay(Integer.valueOf(signDay));
        if (DateUtils.getDayDate(lastSignTime).before(DateUtils.getDayDate(now))) {
            info.setCanSign(Boolean.valueOf(true));
        } else {
            --signDay;
            info.setCanSign(Boolean.valueOf(false));
        }
        info.setCredits(this.getSignCredis(signConfig, signDay));
        info.setNextCredits(this.getSignCredis(signConfig, signDay + 1));
        return info;
    }

    @Override
    public SignResultDto doSignIn(SignConfigEntity signConfig, Long consumerId) throws BiznessException {
        SignResultDto result = new SignResultDto();
        SignRecordDto record = this.signRecordService.findByConsumerId(consumerId);
        int curreyDay = 0;
        if (this.isContinuous(signConfig, record).booleanValue()) {
            curreyDay = record.getSignDay();
        }
        Date now = new Date();
        if (record == null) {
            SignRecordDto insert = new SignRecordDto();
            insert.setSignDay(Integer.valueOf(curreyDay + 1));
            insert.setSignType(Integer.valueOf(1));
            insert.setConsumerId(consumerId);
            insert.setAppId(signConfig.getAppId());
            insert.setFirstSignDay(now);
            insert.setEndSignDay(now);
            this.signRecordService.insert(insert);
        } else {
            SignRecordDto update = new SignRecordDto();
            update.setSignType(Integer.valueOf(1));
            update.setConsumerId(consumerId);
            update.setId(record.getId());
            update.setEndSignDay(now);
            update.setSignDay(Integer.valueOf(curreyDay + 1));
            this.signRecordService.update(update);
        }
        result.setDayNum(Integer.valueOf(curreyDay + 1));
        result.setCredits(this.getSignCredis(signConfig, curreyDay));
        return result;
    }

    private Integer getSignCredis(SignConfigEntity signConfig, Integer signDay) {
        if (StringUtils.isBlank((String)signConfig.getSignCredits())) {
            return 0;
        }
        List credisList = this.spl.splitToList((CharSequence)signConfig.getSignCredits());
        int index = signDay % credisList.size();
        return Integer.valueOf((String)credisList.get(index));
    }
}

