/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.bo.sign;

import cn.com.duiba.consumer.center.api.dto.ConsumerSignInfoDto;
import cn.com.duiba.consumer.center.api.dto.SignRecordDto;
import cn.com.duiba.consumer.center.api.dto.SignResultDto;
import cn.com.duiba.consumer.center.biz.bo.sign.SignHandler;
import cn.com.duiba.consumer.center.biz.entity.sign.SignConfigEntity;
import cn.com.duiba.consumer.center.biz.exception.BiznessException;
import cn.com.duiba.consumer.center.biz.service.SignRecordService;
import com.google.common.base.Objects;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomSignHandler
extends SignHandler {
    @Autowired
    private SignRecordService signRecordService;

    @Override
    public ConsumerSignInfoDto getConsumerSignInfoDto(SignConfigEntity signConfig, SignRecordDto record) {
        ConsumerSignInfoDto info = new ConsumerSignInfoDto();
        info.setSignType(Integer.valueOf(2));
        if (StringUtils.isBlank((String)signConfig.getSignInfoUrl()) || !Objects.equal((Object)2, (Object)signConfig.getSignType())) {
            info.setConfigError(Boolean.valueOf(true));
            return info;
        }
        info.setCanSign(Boolean.valueOf(true));
        info.setSignInfoUrl(signConfig.getSignInfoUrl());
        return info;
    }

    @Override
    public SignResultDto doSignIn(SignConfigEntity signConfig, Long consumerId) throws BiznessException {
        SignResultDto result = new SignResultDto();
        SignRecordDto record = this.signRecordService.findByConsumerId(consumerId);
        int curreyDay = 0;
        if (this.isContinuous(signConfig, record).booleanValue()) {
            curreyDay = record.getSignDay();
        }
        Date now = new Date();
        if (record == null) {
            SignRecordDto insert = new SignRecordDto();
            insert.setSignDay(Integer.valueOf(curreyDay + 1));
            insert.setSignType(Integer.valueOf(2));
            insert.setConsumerId(consumerId);
            insert.setAppId(signConfig.getAppId());
            insert.setFirstSignDay(now);
            insert.setEndSignDay(now);
            this.signRecordService.insert(insert);
        } else {
            SignRecordDto update = new SignRecordDto();
            update.setSignType(Integer.valueOf(2));
            update.setId(record.getId());
            update.setEndSignDay(now);
            update.setConsumerId(consumerId);
            update.setSignDay(Integer.valueOf(curreyDay + 1));
            this.signRecordService.update(update);
        }
        result.setDayNum(Integer.valueOf(curreyDay + 1));
        result.setCredits(Integer.valueOf(0));
        return result;
    }
}

