/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.bo.sign;

import cn.com.duiba.consumer.center.api.dto.ConsumerSignInfoDto;
import cn.com.duiba.consumer.center.api.dto.SignRecordDto;
import cn.com.duiba.consumer.center.api.dto.SignResultDto;
import cn.com.duiba.consumer.center.biz.entity.sign.SignConfigEntity;
import cn.com.duiba.consumer.center.biz.exception.BiznessException;
import cn.com.duiba.consumer.center.biz.support.DateUtils;
import com.google.common.base.Objects;
import java.util.Date;

public abstract class SignHandler {
    public abstract ConsumerSignInfoDto getConsumerSignInfoDto(SignConfigEntity var1, SignRecordDto var2);

    public abstract SignResultDto doSignIn(SignConfigEntity var1, Long var2) throws BiznessException;

    protected Boolean isContinuous(SignConfigEntity signConfig, SignRecordDto record) {
        if (record == null) {
            return false;
        }
        if (!Objects.equal((Object)signConfig.getSignType(), (Object)record.getSignType())) {
            return false;
        }
        Date as = new Date(new Date().getTime() - 86400000L);
        as = DateUtils.getDayDate(as);
        if (!Objects.equal((Object)DateUtils.getDayDate(record.getEndSignDay()), (Object)as) && !Objects.equal((Object)DateUtils.getDayDate(record.getEndSignDay()), (Object)DateUtils.getDayDate(new Date()))) {
            return false;
        }
        return true;
    }

    public SignRecordDto getDefaultRecord(SignConfigEntity signConfig, Long consumerId) {
        SignRecordDto record = new SignRecordDto();
        record.setSignType(signConfig.getSignType());
        record.setAppId(signConfig.getAppId());
        record.setConsumerId(consumerId);
        record.setFirstSignDay(new Date());
        Date as = new Date(new Date().getTime() - 86400000L);
        record.setEndSignDay(as);
        record.setSignDay(Integer.valueOf(0));
        return record;
    }
}

