/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.dao.impl;

import cn.com.duiba.consumer.center.biz.dao.ConsumerDao;
import cn.com.duiba.consumer.center.biz.entity.consumer.ConsumerEntity;
import cn.com.duiba.consumer.center.biz.support.BaseDao;
import cn.com.duiba.consumer.center.biz.support.DatabaseSchema;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class ConsumerDaoImpl
extends BaseDao
implements ConsumerDao {
    private static final String CONSUMER_ID = "consumerId";
    private static final String APP_ID = "appId";
    private static final String PARTNER_USER_ID = "partnerUserId";
    private static final String MAKE_CONSUMER_SEQUENCE = "makeConsumerSequence";
    private static final String CREDITS = "credits";
    private static final String TB_SUFFIX = "tb_suffix";
    private static final String FIND = "find";
    private static final String FIND_BY_APP_AND_PARTNER_USER_ID = "findByAppAndPartnerUserId";

    @Override
    public ConsumerEntity find(Long consumerId) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        return (ConsumerEntity)this.selectOne(FIND, paramMap);
    }

    @Override
    public ConsumerEntity findByAppAndPartnerUserId(Long appId, String partnerUserId) {
        Long cid = this.findInMapByAppAndPartnerUserId(appId, partnerUserId);
        if (cid == null) {
            return null;
        }
        return this.find(cid);
    }

    private Long findInMapByAppAndPartnerUserId(Long appId, String partnerUserId) {
        Map<String, Object> paramMap = this.getTbMapConsumer1024SuffixParamsMap(appId);
        paramMap.put(APP_ID, appId);
        paramMap.put(PARTNER_USER_ID, partnerUserId);
        return (Long)this.selectOne(FIND_BY_APP_AND_PARTNER_USER_ID, paramMap);
    }

    private long makeConsumerSequence() {
        HashMap params = new HashMap();
        this.insert(MAKE_CONSUMER_SEQUENCE, params);
        return Long.valueOf(params.get("id").toString());
    }

    private void insertMapConsume(long consumeId, long appid, String partnerUserId) {
        Map<String, Object> paramMap = this.getTbMapConsumer1024SuffixParamsMap(appid);
        paramMap.put("consumer_id", consumeId);
        paramMap.put("app_id", appid);
        paramMap.put("partner_user_id", partnerUserId);
        this.insert("insertMapConsume", paramMap);
    }

    @Override
    public ConsumerEntity insert(ConsumerEntity consumer) {
        if (consumer.getId() == null) {
            consumer.setId(this.makeConsumerSequence());
        }
        Map<String, Object> map = this.getConsumerTbSuffixParamsMap(consumer.getId());
        consumer.setTbsuffix(String.valueOf(map.get(TB_SUFFIX)));
        this.insert("insert", consumer);
        this.insertMapConsume(consumer.getId(), consumer.getAppId(), consumer.getPartnerUserId());
        return consumer;
    }

    @Override
    public int updateCredits(Long consumerId, Long credits) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("id", consumerId);
        paramMap.put(CREDITS, credits);
        return this.update("updateCredits", paramMap);
    }

    @Override
    public int increaseCredits(Long consumerId, Long credits) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put(CREDITS, credits);
        return this.update("increaseCredits", paramMap);
    }

    @Override
    public int decrementCredits(Long consumerId, Long credits) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put(CREDITS, credits);
        return this.update("decrementCredits", paramMap);
    }

    @Override
    public int updateAutologinParams(Long consumerId, Long credits, String alipay, String qq, String phone, Integer vipLevel) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put(CREDITS, credits);
        paramMap.put("alipay", alipay);
        paramMap.put("qq", qq);
        paramMap.put("phone", phone);
        paramMap.put("vipLevel", vipLevel == null ? 0 : vipLevel);
        return this.update("updateAutologinParams", paramMap);
    }

    @Override
    public int updateUnreadCount(Long consumerId, int count) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put("count", count);
        return this.update("updateUnreadCount", paramMap);
    }

    @Override
    public int updateLastAlipay(Long consumerId, String lastAlipay, String lastRealname) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put("lastAlipay", lastAlipay);
        paramMap.put("lastRealname", lastRealname);
        return this.update("updateLastAlipay", paramMap);
    }

    @Override
    public int updateAddress(Long consumerId, String addrName, String addrProvince, String addrCity, String addrArea, String addrDetail, String addrPhone) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put("addrName", addrName);
        paramMap.put("addrProvince", addrProvince);
        paramMap.put("addrCity", addrCity);
        paramMap.put("addrArea", addrArea);
        paramMap.put("addrDetail", addrDetail);
        paramMap.put("addrPhone", addrPhone);
        return this.update("updateAddress", paramMap);
    }

    @Override
    public int updateLastPhone(Long consumerId, String lastPhone) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put("lastPhone", lastPhone);
        return this.update("updateLastPhone", paramMap);
    }

    @Override
    public int updateLastQq(Long consumerId, String lastQq) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put(CONSUMER_ID, consumerId);
        paramMap.put("lastQq", lastQq);
        return this.update("updateLastQq", paramMap);
    }

    private Map<String, Object> getConsumerTbSuffixParamsMap(Long id) {
        Long tbLong = id / 10000000L;
        int tbInt = tbLong.intValue();
        String tb = Integer.toString(tbInt);
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TB_SUFFIX, tb);
        return params;
    }

    private Map<String, Object> getTbMapConsumer1024SuffixParamsMap(Long appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TB_SUFFIX, this.getTableMapConsumerSuffix(appId));
        return params;
    }

    private String getTableMapConsumerSuffix(Long appId) {
        int tbInt = appId.intValue() % 1024;
        if (tbInt < 0) {
            tbInt = -tbInt;
        }
        String tb = Integer.toString(tbInt);
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }
        return tb;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CONSUMER;
    }
}

