/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.remoteservice.impl;

import cn.com.duiba.consumer.center.api.dto.AppSignConfigDto;
import cn.com.duiba.consumer.center.api.dto.ConsumerSignInfoDto;
import cn.com.duiba.consumer.center.api.dto.SignResultDto;
import cn.com.duiba.consumer.center.api.params.AppSignConfigParams;
import cn.com.duiba.consumer.center.api.params.SignLogParams;
import cn.com.duiba.consumer.center.api.params.SignParams;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteSignSystemService;
import cn.com.duiba.consumer.center.biz.bo.SignSystemBo;
import cn.com.duiba.consumer.center.biz.exception.BiznessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteSignSystemServiceImpl
implements RemoteSignSystemService {
    @Autowired
    private SignSystemBo signSystemBo;

    public DubboResult<ConsumerSignInfoDto> getConsumerSignInfoDto(Long consumerId) {
        return DubboResult.successResult((Object)this.signSystemBo.getSignInfo(consumerId));
    }

    public DubboResult<SignResultDto> doSignIn(SignParams params) {
        try {
            SignResultDto result = this.signSystemBo.doSignIn(params);
            return DubboResult.successResult((Object)result);
        }
        catch (BiznessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AppSignConfigDto> getSignInConfigInfo(Long appId) {
        AppSignConfigDto dto = this.signSystemBo.getSignInConfigInfo(appId);
        return DubboResult.successResult((Object)dto);
    }

    public DubboResult<Boolean> updateSignInConfig(AppSignConfigParams params) {
        return DubboResult.successResult((Object)this.signSystemBo.updateSignInConfig(params));
    }

    public DubboResult<Long> createSignLog(SignLogParams params) {
        return DubboResult.successResult((Object)this.signSystemBo.createSignLog(params));
    }

    public DubboResult<Boolean> setSignLogStatue(Long logId, Integer logStatue) {
        return DubboResult.successResult((Object)this.signSystemBo.setSignLogStatue(logId, logStatue));
    }
}

