/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.service.impl;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import cn.com.duiba.consumer.center.biz.service.ConsumerPCGOrderRecordService;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ConsumerPCGOrderRecordServiceImpl
implements ConsumerPCGOrderRecordService {
    private static DuiBaLogger LOGGER = DuiBaLoggerFactory.getLogger(ConsumerPCGOrderRecordServiceImpl.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private RedisBatchCache redisBatchCache = new RedisBatchCache();

    @Override
    public Long getLastTimeOrderRecord(Long consumerId, GoodsTypeEnum gtype, Long pcgId) {
        LOGGER.info("\u83b7\u53d6\u7528\u6237\u8ba2\u5355ID----->consumerId\uff1a" + consumerId + ",pcgId\uff1a" + pcgId + " \u7f13\u5b58key\uff1a" + this.redisBatchCache.getBatchsCache(consumerId, gtype, pcgId));
        return this.redisBatchCache.getBatchsCache(consumerId, gtype, pcgId);
    }

    @Override
    public Boolean saveLastTimeOrderRecord(Long consumerId, GoodsTypeEnum gtype, Long pcgId, Long orderId) {
        this.redisBatchCache.setBatchsCache(consumerId, gtype, pcgId, orderId);
        return true;
    }

    public class RedisBatchCache {
        public Long getBatchsCache(Long consumerId, GoodsTypeEnum gtype, Long pcgId) {
            String string = (String)ConsumerPCGOrderRecordServiceImpl.this.redisTemplate.opsForValue().get((Object)this.getRedisBatchsKey(consumerId, gtype, pcgId));
            if (string == null) {
                return null;
            }
            return Long.parseLong(string);
        }

        public void setBatchsCache(Long consumerId, GoodsTypeEnum gtype, Long pcgId, Long orderId) {
            String string = orderId.toString();
            ConsumerPCGOrderRecordServiceImpl.this.redisTemplate.opsForValue().set((Object)this.getRedisBatchsKey(consumerId, gtype, pcgId), (Object)string);
            ConsumerPCGOrderRecordServiceImpl.this.redisTemplate.expire((Object)this.getRedisBatchsKey(consumerId, gtype, pcgId), 60L, TimeUnit.DAYS);
            LOGGER.info("\u83b7\u53d6\u7528\u6237\u8ba2\u5355ID----->consumerId\uff1a" + consumerId + ",pcgId\uff1a" + pcgId + " \u7f13\u5b58key\uff1a" + this.getRedisBatchsKey(consumerId, gtype, pcgId) + ",\u7f13\u5b58value\uff1a" + string);
        }

        private String getRedisBatchsKey(Long consumerId, GoodsTypeEnum gtype, Long pcgId) {
            return "consumer-consumer_Id_" + consumerId + gtype.getGtype() + pcgId;
        }
    }
}

