/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.service.impl;

import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.consumer.center.biz.dao.ConsumerDao;
import cn.com.duiba.consumer.center.biz.entity.consumer.ConsumerEntity;
import cn.com.duiba.consumer.center.biz.service.ConsumerService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsumerServiceImpl
implements ConsumerService {
    @Resource
    private ConsumerDao consumerDao;
    @Autowired
    private CacheClient memcachedClient;

    private static String getMemKey(Long consumerId) {
        return "consumer-consumer_Id_" + consumerId;
    }

    private ConsumerDto getConsumerInCache(Long consumerId) {
        return (ConsumerDto)this.memcachedClient.get(ConsumerServiceImpl.getMemKey(consumerId));
    }

    private void setConsumerInCache(ConsumerDto consumer) {
        this.memcachedClient.set(ConsumerServiceImpl.getMemKey(consumer.getId()), (Object)consumer, 120);
    }

    private void clearConsumerCache(long consumerId) {
        this.memcachedClient.remove(ConsumerServiceImpl.getMemKey(consumerId));
    }

    @Override
    public ConsumerDto find(Long consumerId) {
        ConsumerDto consumer = this.getConsumerInCache(consumerId);
        if (consumer != null) {
            return consumer;
        }
        ConsumerDto c = (ConsumerDto)BeanUtils.copy((Object)this.consumerDao.find(consumerId), ConsumerDto.class);
        this.setConsumerInCache(c);
        return c;
    }

    @Override
    public List<ConsumerDto> findAllByIds(List<Long> ids) {
        ArrayList<ConsumerDto> result = new ArrayList<ConsumerDto>();
        for (Long id : ids) {
            ConsumerDto c = this.find(id);
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public ConsumerDto findByAppAndPartnerUserId(Long appId, String partnerUserId) {
        return (ConsumerDto)BeanUtils.copy((Object)this.consumerDao.findByAppAndPartnerUserId(appId, partnerUserId), ConsumerDto.class);
    }

    @Override
    @Transactional(value="consumer")
    public ConsumerDto insert(ConsumerDto consumer) {
        ConsumerEntity e = (ConsumerEntity)BeanUtils.copy((Object)consumer, ConsumerEntity.class);
        ConsumerEntity ret = this.consumerDao.insert(e);
        return (ConsumerDto)BeanUtils.copy((Object)ret, ConsumerDto.class);
    }

    @Override
    public int updateCredits(Long consumerId, Long credits) {
        int ret = this.consumerDao.updateCredits(consumerId, credits);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int increaseCredits(Long consumerId, Long credits) {
        int ret = this.consumerDao.increaseCredits(consumerId, credits);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int decrementCredits(Long consumerId, Long credits) {
        int ret = this.consumerDao.decrementCredits(consumerId, credits);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int updateAutologinParams(Long consumerId, Long credits, String alipay, String qq, String phone, Integer vipLevel) {
        int ret = this.consumerDao.updateAutologinParams(consumerId, credits, alipay, qq, phone, vipLevel);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int updateUnreadCount(Long consumerId, int count) {
        int ret = this.consumerDao.updateUnreadCount(consumerId, count);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int updateLastAlipay(Long consumerId, String lastAlipay, String lastRealname) {
        int ret = this.consumerDao.updateLastAlipay(consumerId, lastAlipay, lastRealname);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int updateAddress(Long consumerId, String addrName, String addrProvince, String addrCity, String addrArea, String addrDetail, String addrPhone) {
        int ret = this.consumerDao.updateAddress(consumerId, addrName, addrProvince, addrCity, addrArea, addrDetail, addrPhone);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int updateLastPhone(Long consumerId, String lastPhone) {
        int ret = this.consumerDao.updateLastPhone(consumerId, lastPhone);
        this.clearConsumerCache(consumerId);
        return ret;
    }

    @Override
    public int updateLastQq(Long consumerId, String lastQq) {
        int ret = this.consumerDao.updateLastQq(consumerId, lastQq);
        this.clearConsumerCache(consumerId);
        return ret;
    }
}

