/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.consumer.center.biz.service.impl;

import cn.com.duiba.consumer.center.biz.dao.SignConfigDao;
import cn.com.duiba.consumer.center.biz.entity.sign.SignConfigEntity;
import cn.com.duiba.consumer.center.biz.exception.CodeRuntimeException;
import cn.com.duiba.consumer.center.biz.service.SignConfigService;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.base.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignConfigServiceImpl
implements SignConfigService {
    @Autowired
    private SignConfigDao signConfigDao;
    @Autowired
    private CacheClient memcachedClient;

    @Override
    public void saveSignConfig(SignConfigEntity entity) {
        if (entity.getAppId() == null) {
            throw new CodeRuntimeException("\u66f4\u65b0\u7b7e\u5230\u914d\u7f6e\u5fc5\u987b\u6307\u5b9aAppId");
        }
        SignConfigEntity old = this.signConfigDao.findByAppId(entity.getAppId());
        if (Objects.equal(null, (Object)old)) {
            this.signConfigDao.insert(entity);
        } else {
            this.signConfigDao.update(entity);
            this.clearSignConfigInCache(entity.getAppId());
        }
    }

    @Override
    public SignConfigEntity findSignConfigByAppId(Long appId) {
        SignConfigEntity entity = this.getSignConfigInCache(appId);
        if (entity == null) {
            entity = this.signConfigDao.findByAppId(appId);
            this.setSignConfigInCache(entity);
        }
        return entity;
    }

    private static String getMemKey(Long appId) {
        return "sign-config_appId_" + appId;
    }

    private SignConfigEntity getSignConfigInCache(Long appId) {
        return (SignConfigEntity)this.memcachedClient.get(SignConfigServiceImpl.getMemKey(appId));
    }

    private void setSignConfigInCache(SignConfigEntity config) {
        if (config == null) {
            return;
        }
        this.memcachedClient.set(SignConfigServiceImpl.getMemKey(config.getAppId()), (Object)config, 120);
    }

    private void clearSignConfigInCache(long appId) {
        this.memcachedClient.remove(SignConfigServiceImpl.getMemKey(appId));
    }
}

